<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\LetterHeadTemplate;
use App\Observers\LetterHeadTemplateObserver;
use App\Scopes\CompanyScope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LetterHeadSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */

    public function run()
    {
        Model::unguard();

        DB::table('letterhead_templates')->delete();

        DB::statement('ALTER TABLE letterhead_templates AUTO_INCREMENT = 1');
        DB::statement('ALTER TABLE increments_promotions AUTO_INCREMENT = 1');

        $company = Company::with(['currency' => function ($query) {
            return $query->withoutGlobalScope(CompanyScope::class);
        }, 'subscriptionPlan'])->where('is_global', 0)->first();
        session(['company' => $company]);

        // Manually Dispatch Events
        LetterHeadTemplate::observe(LetterHeadTemplateObserver::class);

        $attendanceAwardTemplate = new LetterHeadTemplate();
        $attendanceAwardTemplate->company_id = $company->id;
        $attendanceAwardTemplate->title = 'Attendance Award';
        $attendanceAwardTemplate->description = '<p class="ql-align-justify"><br></p><p class="ql-align-justify"><strong>##EMPLOYEE_NAME##</strong></p><p class="ql-align-justify"><strong style="color: rgb(0, 0, 0); background-color: transparent;">Employee ID : ##EMPLOYEE_ID##</strong></p><p class="ql-align-justify"><strong style="color: rgb(0, 0, 0); background-color: transparent;">Designation : ##EMPLOYEE_DESIGNATION## </strong></p><p><strong style="color: rgb(0, 0, 0); background-color: transparent;">Date : ##CURRENT_DATE##</strong></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><img src="https://lh7-rt.googleusercontent.com/docsz/AD_4nXdLmrryqZRIy34-rM-P7x3K9LtfBF-YBaV9XqihdSjpS5doCVzX8Rm-EsqwKgN82uqWJqFcCLoAcuFa-cnl_BotmYKW7EIVsuR2p5YEX6XnZwZXLdHlFXLBdWnl-S_BvF48UOfIFqBO5AkmOOTpYQ_LZHUNJ8HOl-J7zhNMz85vIuB8_tiOnHY?key=NAXd1FVSD65-hvgU4AI2tg" alt="horizontal line" height="2" width="661"></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">Subject: Excellent Attendance Letter</span></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">Congratulations! </span></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">You have been provided an attendance award bonus, for your excellent attendance at work during the last 3 month’s. The effort you put into your job is more than what is required and </span><strong style="color: rgb(0, 0, 0); background-color: transparent;">##COMPANY_NAME##</strong><span style="color: rgb(0, 0, 0); background-color: transparent;"> Team is going to recognize you. Your enthusiasm and interest to work in the company, in spite of difficulties, have made a huge impact to our success.</span></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">You are a valuable employee to our company. We expect you to continue dedicated work and earn more such bonuses in upcoming months.</span></p><p><br></p><p><br></p><p><br></p><p><br></p><p><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">Signature of designated person</span></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">For </span><strong style="color: rgb(0, 0, 0); background-color: transparent;">##COMPANY_NAME##</strong></p><p><br></p>';
        $attendanceAwardTemplate->save();

        $attendanceAwardTemplate = new LetterHeadTemplate();
        $attendanceAwardTemplate->company_id = $company->id;
        $attendanceAwardTemplate->title = 'Salary Letter';
        $attendanceAwardTemplate->description = '<p class="ql-align-justify"><br></p><p class="ql-align-justify"><strong style="background-color: transparent; color: rgb(0, 0, 0);">To Whom It May Concern</strong><span style="background-color: transparent; color: rgb(0, 0, 0);">,</span></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">This is to certify that </span><strong style="background-color: transparent; color: rgb(0, 0, 0);">##EMPLOYEE_NAME## (##EMPLOYEE_ID##)</strong><span style="background-color: transparent; color: rgb(0, 0, 0);">, holding the position of </span><strong style="background-color: transparent; color: rgb(0, 0, 0);">##EMPLOYEE_DESIGNATION##</strong><span style="background-color: transparent; color: rgb(0, 0, 0);"> at </span><strong style="background-color: transparent; color: rgb(0, 0, 0);">##COMPANY_NAME##</strong><span style="background-color: transparent; color: rgb(0, 0, 0);">, has been receiving a monthly salary of INR </span>xxxx<span style="background-color: transparent; color: rgb(0, 0, 0);"> (</span>xxxx<span style="background-color: transparent; color: rgb(0, 0, 0);"> Rupees Only).</span></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">The details of the salary received for the period of </span><strong style="background-color: transparent; color: rgb(0, 0, 0);">October ##CURRENT_YEAR## to December ##CURRENT_YEAR##</strong><span style="background-color: transparent; color: rgb(0, 0, 0);"> are as follows:</span></p><p><br></p><table><tbody><tr><td data-row="1"><span style="background-color: transparent; color: rgb(0, 0, 0);">Month</span></td><td data-row="1"><span style="background-color: transparent; color: rgb(0, 0, 0);">Salary (INR)</span></td></tr><tr><td data-row="2"><span style="background-color: transparent; color: rgb(0, 0, 0);">October ##CURRENT_YEAR##</span></td><td data-row="2">xxxx</td></tr><tr><td data-row="3"><span style="background-color: transparent; color: rgb(0, 0, 0);">November ##CURRENT_YEAR##</span></td><td data-row="3">xxxx</td></tr><tr><td data-row="4"><span style="background-color: transparent; color: rgb(0, 0, 0);">December ##CURRENT_YEAR##</span></td><td data-row="4">xxxx</td></tr></tbody></table><p><br></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">This certificate is issued upon request for official purposes.</span></p><p><br></p><p><br></p><p><br></p><p><br></p><p><br></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">Signature of designated person</span></p><p class="ql-align-justify">##COMPANY_NAME##</p><p class="ql-align-justify">##CURRENT_DATE##</p><p><br></p>';
        $attendanceAwardTemplate->save();

        $attendanceAwardTemplate = new LetterHeadTemplate();
        $attendanceAwardTemplate->company_id = $company->id;
        $attendanceAwardTemplate->title = 'Appreciation Letter';
        $attendanceAwardTemplate->description = '<p class="ql-align-justify"><strong>##EMPLOYEE_NAME##</strong></p><p class="ql-align-justify"><strong style="background-color: transparent; color: rgb(0, 0, 0);">Employee ID : ##EMPLOYEE_ID##</strong></p><p class="ql-align-justify"><strong style="background-color: transparent; color: rgb(0, 0, 0);">Designation : ##EMPLOYEE_DESIGNATION##</strong></p><p class="ql-align-justify"><strong style="background-color: transparent; color: rgb(0, 0, 0);">Date : ##CURRENT_DATE##</strong></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><img src="https://lh7-rt.googleusercontent.com/docsz/AD_4nXdE1QmfIjp9ZxEyNe_zDtpnQnKEv3WD5h2uU4G5BO12wqC1GtxVZaMqNODvzAPcXxyu-vmihX3TkH6zZcDH1aAfqwqAXDVGGIVCASgnZaZRinnDkwbJsv47t3cq1-RWQga_zTJV88qvSfUkwRv8tbf5EuR8xGw1Fxf8ICI6a5_ARPoVfTPchw?key=OH6sk66lM-DsNuOy0zNU0Q" alt="horizontal line" height="2" width="661"></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">Subject: Appreciation Letter</span></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">Congratulations! </span></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">You have been provided a performance bonus, for your excellent performance in month of </span><strong style="background-color: transparent; color: rgb(0, 0, 0);">##CURRENT_MONTH## ##CURRENT_YEAR##</strong><span style="background-color: transparent; color: rgb(0, 0, 0);">. We want to appreciate that because of your hard work, the company has increased in size and profitability. Your enthusiasm and interest to work in the company, in spite of difficulties, have made a huge impact to our success.</span></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">You are a valuable employee to our company. We expect you to continue dedicated work and earn more such bonuses in upcoming months.</span></p><p><br></p><p><br></p><p><br></p><p><br></p><p><br></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">Signature of designated person</span></p><p class="ql-align-justify"><span style="background-color: transparent; color: rgb(0, 0, 0);">For ##COMPANY_NAME##</span></p><p><br></p>';
        $attendanceAwardTemplate->save();

        $attendanceAwardTemplate = new LetterHeadTemplate();
        $attendanceAwardTemplate->company_id = $company->id;
        $attendanceAwardTemplate->title = 'Increment Letter';
        $attendanceAwardTemplate->description = '<p class="ql-align-justify"><strong>##EMPLOYEE_NAME##</strong></p><p class="ql-align-justify"><strong style="color: rgb(0, 0, 0); background-color: transparent;">Employee ID : ##EMPLOYEE_ID##</strong></p><p class="ql-align-justify"><strong style="color: rgb(0, 0, 0); background-color: transparent;">Designation : ##EMPLOYEE_DESIGNATION##</strong></p><p class="ql-align-justify"><strong style="color: rgb(0, 0, 0); background-color: transparent;">Date : ##CURRENT_DATE##</strong></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><img src="https://lh7-rt.googleusercontent.com/docsz/AD_4nXdE1QmfIjp9ZxEyNe_zDtpnQnKEv3WD5h2uU4G5BO12wqC1GtxVZaMqNODvzAPcXxyu-vmihX3TkH6zZcDH1aAfqwqAXDVGGIVCASgnZaZRinnDkwbJsv47t3cq1-RWQga_zTJV88qvSfUkwRv8tbf5EuR8xGw1Fxf8ICI6a5_ARPoVfTPchw?key=OH6sk66lM-DsNuOy0zNU0Q" alt="horizontal line" height="2" width="661"></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">Subject: Salary Increment</span></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">Congratulations!</span></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">We would like to gladly inform you that your salary will be increased by </span><strong style="color: rgb(0, 0, 0); background-color: transparent;">₹XXXX</strong><span style="color: rgb(0, 0, 0); background-color: transparent;"> starting </span><strong style="color: rgb(0, 0, 0); background-color: transparent;">1st ##CURRENT_MONTH## ##CURRENT_YEAR##</strong><span style="color: rgb(0, 0, 0); background-color: transparent;"> and your new salary will be </span><strong style="color: rgb(0, 0, 0); background-color: transparent;">₹XXXX</strong><span style="color: rgb(0, 0, 0); background-color: transparent;">.</span></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">This increase is the result of excellent performance at Codraj and your continuous contribution to the success of this company. We recognize your efforts and would like to reward you for that.</span></p><p class="ql-align-justify"><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">We also hope this will encourage you to perform even better. There is always room for improvement. Keep up the good work.</span></p><p><br></p><p><br></p><p><br></p><p><br></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">Signature of designated person</span></p><p class="ql-align-justify"><span style="color: rgb(0, 0, 0); background-color: transparent;">For ##COMPANY_NAME##</span></p><p><br></p>';
        $attendanceAwardTemplate->save();
    }
}
