<?php

namespace App\Classes;

use App\Models\Lang;
use App\Models\Translation;
use League\CommonMark\Reference\Reference;
use Nwidart\Modules\Facades\Module;

class LangTrans
{
    public static $mainTranslations = [
        'common' => [
            'enabled' => 'Enabled',
            'disabled' => 'Disabled',
            'working' => 'Working',
            'not_working' => 'Not Working',
            'id' => 'Id',
            'action' => 'Action',
            'placeholder_default_text' => 'Please Enter {0}',
            'placeholder_social_text' => 'Please Enter {0} Url',
            'placeholder_search_text' => 'Search By {0}',
            'select_default_text' => 'Select {0}...',
            'create' => 'Create',
            'edit' => 'Edit',
            'update' => 'Update',
            'cancel' => 'Cancel',
            'delete' => 'Delete',
            'success' => 'Success',
            'error' => 'Error',
            'yes' => 'Yes',
            'no' => 'No',
            'fix_errors' => 'Please Fix Below Errors.',
            'cancelled' => 'Cancelled',
            'pending' => 'Pending',
            'paid' => 'Paid',
            'completed' => 'Completed',
            'save' => 'Save',
            'all' => 'All',
            'name' => 'Name',
            'back' => 'Back',
            'max_amount' => 'Max. Amount',
            'date_time' => 'Date Time',
            'select_time' => 'Select Time',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'search' => 'Search',
            'date' => 'Date',
            'confirm' => 'Confirm',
            'title' => 'Title',
            'value' => 'Value',
            'add' => 'Add',
            'view' => 'View',
            'edit' => 'Edit',
            'download' => 'Download',
            'total' => 'Total',
            'email' => 'Email',
            'phone' => 'Phone',
            'purchase_code' => 'Purchase Code',
            'verify_purchase' => 'Verify Purchase',
            'install' => 'Install',
            'installing' => 'Installing',
            'updating' => 'Updating',
            'free' => 'Free',
            'paid' => 'Paid',
            'domain' => 'Domain',
            'verify' => 'Verify',
            'send' => 'Send',
            'upload' => 'Upload',
            'view_all' => 'View All',
            'unpaid' => 'Unpaid',
            'loading' => 'Loading',
            'update_app' => 'Update App',
            'welcome_back' => 'Welcome {0}',
            'off' => 'Off',
            'on_create' => 'On Create',
            'on_update' => 'On Update',
            'on_delete' => 'On Delete',
            'demo_account_credentials' => 'Demo account login credentials',
            'created_by' => 'Created By',
            'import' => 'Import',
            'file' => 'File',
            'copy_url' => 'Copy Url',
            'print' => 'Print',
            'amount' => 'Amount',
            'status' => 'Status',
            'active' => 'Active',
            'inactive' => 'Inactive',
            'verified' => 'Verified',
            'configure' => 'Configure',
            'logo' => 'Logo',
            'slug' => 'Slug',
            'description' => 'Description',
            'image' => 'Image',
            'address' => 'Address',
            'not_allowed' => 'Not Allowed',
            'details' => 'Details',
            'minutes' => 'Minute',
            'pending' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'january' => 'January',
            'february' => 'February',
            'march' => 'March',
            'april' => 'April',
            'may' => 'May',
            'june' => 'June',
            'july' => 'July',
            'august' => 'August',
            'september' => 'September',
            'october' => 'October',
            'november' => 'November',
            'december' => 'December',
            'hrm_permissions' => 'HRM Permissions',
            'am' => 'AM',
            'pm' => 'PM',
            'sunday' => 'Sunday',
            'monday' => 'Monday',
            'tuesday' => 'Tuesday',
            'wednesday' => 'Wednesday',
            'thursday' => 'Thursday',
            'friday' => 'Friday',
            'saturday' => 'Saturday',
            'holiday' => 'Holiday',
            'weekends' => 'Weekends',
            'both' => 'Both',
            'publicly' => 'Publicly',
            'internal_employee' => 'Internal Employee',
            'open' => 'Open',
            'closed' => 'Closed',
            'initial' => 'Initial',
            'shortlist' => 'Shortlist',
            'interview' => 'Interview',
            'selected' => 'Selected',
            'rejected' => 'Rejected',
            'close' => 'Closed',
            'draft' => 'Draft',
            'published' => 'Published',
            'all' => 'All',
            'select_employee' => 'Select Employees',
            'text' => 'Text',
            'add_edit' => 'Add/Edit',
            'name_email' => 'Name/Email/Phone',
            'submit' => 'Submit',
            'input' => 'Input',
            'text_area' => 'Text Area',
            'self' => 'Self',
            'manager' => 'Manager',
            'preview' => 'Preview',
            'generated' => 'Payroll Generated Sucessfully',
            'regenerated' => 'Payroll Regenerated Sucessfully',
            'broken_by_you' => 'Broken Assets By You',
            'all_asset' => 'All Lend Assets',
            'expired' => 'Expired',
            'approved_message' => 'are you sure you want to approved this request?',
            'rejected_message' => 'are you sure you want to reject this request?',
            'send' => 'Send',
            'manage_company_expense' => 'Manage Company Expense',
            'status_changed' => 'Status Changed',
            'mm' => 'mm',
            'px' => 'px',
            'approve' => 'Approve',
            'reject' => 'Reject',
            'approve/reject' => 'Approve or Reject',
            'before_break' => 'Before Half',
            'after_break' => 'After Half',
            'select_date' => 'Select Date',
            'ok' => 'Ok',
            'clear' => 'Clear',
            'filters' => 'Filters',
            'visible' => 'Visible',
            'hidden' => 'Hidden',
            'message' => 'Message',
            'employee_specific' => 'Employee Specific',
            'company_specific' => 'Company Specific',
            'override_existing_data' => 'Override Existing Data',
            'month' => 'Month',
            'sample_attendance_file' => 'Sample Attendance File',
            'sample_lang_file' => 'Sample Language File',
            'export' => 'Export',
            'show_company_header_footer' => 'Show Company Header & Footer',
            'doc_type' => 'Document Type',
            'csv' => 'CSV',
            'excel' => 'Excel',
            'pdf' => 'PDF',
        ],
        'menu' => [
            'dashboard' => 'Dashboard',
            'users' => 'Users',
            'staff_members' => 'Employees',
            'settings' => 'Settings',
            'company' => 'Company Settings',
            'profile' => 'Profile',
            'translations' => 'Translations',
            'languages' => 'Languages',
            'roles' => 'Role & Permissions',
            'currencies' => 'Currencies',
            'login' => 'Login',
            'logout' => 'Logout',
            'verify_product' => 'Verify Product',
            'modules' => 'Modules',
            'storage_settings' => 'Storage Settings',
            'email_settings' => 'Email Settings',
            'update_app' => 'Update App',
            'database_backup' => 'Database Backup',
            'companies' => 'Companies',
            'departments' => 'Departments',
            'designations' => 'Designations',
            'hrm' => 'HRM',
            'holidays' => 'Holidays',
            'weekends' => 'Weekends',
            'leaves_types' => 'Leave Types',
            'leaves' => 'Leaves',
            'shifts' => 'Shifts',
            'pre_payments' => 'Pre Payments',
            'attendances' => 'Attendance',
            'staff' => 'Staff',
            'all_holidays' => 'All Holidays',
            'leave_types' => 'Leave Types',
            'remaining_leaves' => 'Remaining Leaves',
            'unpaid_leaves' => 'Unpaid Leaves',
            'summary' => 'Summary',
            'awards' => 'Awards',
            'appreciations' => 'Appreciations',
            'increments_promotions' => 'Increment/Promotion',
            'payrolls' => 'Payroll',
            'dashboards' => 'HRM Dashboard',
            'attendance_details' => 'Attendance Details',
            'attendance_summary' => 'Attendance Summary',
            'basic_salaries' => 'Employee Salaries',
            'hrm_settings' => 'HRM Settings',
            'expense_manager' => 'Expenses',
            'expense_categories' => 'Expense Categories',
            'expenses' => 'Expenses',
            'locations' => 'Locations',
            'assets' => 'Assets',
            'jobs' => 'Jobs',
            'news' => 'News',
            'asset_types' => 'Asset Types',
            'complaints' => 'Complaints',
            'forms' => 'Forms',
            'survey_forms' => 'Survey Forms',
            'assigned_survey' => 'Assigned Survey',
            'feedbacks' => 'Survey Forms',
            'company_policies' => 'Company Policies',
            'accountings' => 'Accountings',
            'accounts' => 'Accounts',
            'payees' => 'Payees',
            'payers' => 'Payers',
            'deposit_categories' => 'Deposit Categories',
            'deposits' => 'Deposits',
            'salary_setting' => 'Salary Setting',
            'employees' => 'Employees',
            'asset_lent_return' => 'Asset Lent/Return Settings',
            'mark_holiday_settings' => 'Mark Holiday Settings',
            'finance' => 'Finance',
            'warnings' => 'Warnings',
            'offboardings' => 'Offboardings',
            'resignations' => 'Resignations',
            'terminations' => 'Terminations',
            'application' => 'Application Form',
            'letter_heads' => 'Letter Heads',
            'templates' => 'Templates',
            'generates' => 'Generates',
            'indicators' => 'Review Indicators',
            'upcoming_holidays' => 'Upcoming Holidays',
            'upcoming_birthdays' => 'Upcoming Birthdays',
            'search_title' => 'Search Title',
            'weekend_holiday' => 'Weekend/Holiday',
            'company_policy' =>  'Company Policy',
            'news' => 'News',
            'download' => 'Download',
            'salary_groups' => 'Salary Group',
            'salary_components' => 'Salary Component',
            'payroll_settings' => 'Payroll Settings',
            'leave_approve_reject' => 'Leave Approve/Reject',
            'pdf_fonts' => 'Pdf Fonts',
            'company_expense' => 'Company Expense',
            'expense_approve_reject' => 'Expense Approve/Reject',
            'employee_work_status' => 'Employee Work Status',
            'performance' => 'Performance',
            'team_birthdays' => 'Team Birthdays',
            'send_wishes' => 'Send Wishes',
            'font_settings' => 'Pdf Font Setting',
            'work_hour_details' => 'Working Hour Details',
            'reports' => 'Reports',
            'employee_custom_fields' => 'Employee Custom Fields',
            'email_templates' => 'Email Templates',
            'custom_data_fields' => 'Custom Data Fields',
            'menu' => 'Menu',
            'self' => 'Self',
            'paid_leaves' => 'Paid Leaves',
        ],
        'dashboard' => [
            'dashboard' => 'Dashboard',
            'total_employees' => 'Total Employees',
            'total_active_employees' => 'Total Active Employees',
            'payment_sent' => 'Payment Sent',
            'payment_received' => 'Payment Received',
            'total_inactive_employees' => 'Total Inactive Employees',
            'work_anniversary' => 'Work Anniversary',
            'employee_under_you' => 'Employee Under You',
            'total_sales' => 'Total Sales',
            'total_expenses' => 'Total Expenses'
        ],
        'user' => [
            'add' => 'Add New Employee',
            'edit' => 'Edit Employee',
            'created' => 'Employee Created Successfully',
            'updated' => 'Employee Updated Successfully',
            'deleted' => 'Employee Deleted Successfully',
            'staff_members_details' => 'Employee Details',
            'staff_member' => 'Employee',
            'delete_message' => 'Are you sure you want to delete this employee?',
            'selected_delete_message' => 'Are you sure you want to delete selected employee?',
            'import_staff_members' => 'Import Employees',
            'email_phone' => 'Email or Phone',
            'user' => 'User',
            'name' => 'Name',
            'created_at' => 'Created At',
            'working_email' => 'Working Email',
            'password' => 'Password',
            'login_enabled' => 'Login Enabled',
            'profile_image' => 'Profile Image',
            'company_name' => 'Company Name',
            'working_phone' => 'Working Phone',
            'allow_login' => 'Allow Login',
            'address' => 'Address',
            'city' => 'City',
            'state' => 'State',
            'country' => 'Country',
            'zipcode' => 'Zipcode',
            'status' => 'Status',
            'role' => 'Role',
            'profile_updated' => 'Profile Updated Successfully',
            'password_blank' => "Leave blank if you don't want to update password.",
            'admin_account_details' => "Admin Account Details",
            'import_users' => 'Import Users',
            'department_id' => 'Department',
            'designation_id' => 'Designation',
            'shift_id' => 'Shift',
            'staff' => 'Staff',
            'basic_salary' => 'Basic Salary',
            'email' => 'Email',
            'location_id' => 'Location',
            'employee_id' => 'Employee Id',
            'date' => 'Date',
            'gender' => 'Gender',
            'date_of_birth' => 'Date Of Birth',
            'joining_date' => 'Joining Date',
            'male' => 'Male',
            'female' => 'Female',
            'other' => 'Other',
            'basic_info' => 'Basic Info',
            'personal_info' => 'Personal Info',
            'work_info' => 'Work Info',
            'is_married' => 'Is Married',
            'marriage_date' => 'Marriage Date',
            'personal_email' => 'Personal Email',
            'personal_phone' => 'Personal Phone',
            'report_to' => 'Report To',
            'is_manager' => 'Is Manager',
            'visibility' => 'Visibilty',
            'company_relation' => 'Company Relation',
            'end_date' => 'End Date',
            'manager' => 'Manager',
            'department' => 'Department',
            'location' => 'Location',
            'company' => 'Company',
            'employee_profile' => 'Employee Profile',
            'about' => 'About',
            'apprecation' => 'Apprecation',
            'assets' => 'Assets',
            'leaves' => 'Leaves',
            'award' => 'Award',
            'price_amount' => 'Price Amount',
            'price_given' => 'Price Given',
            'description' => 'Description',
            'leave_type' => 'Leave Type',
            'start_date' => 'Start Date',
            'is_half_day' => 'Is Half Day',
            'reason' => 'Reason',
            'is_paid' => 'Is Paid',
            'total_leaves' => 'Total Leaves',
            'max_leaves_per_month' => 'Max Leaves Per Month',
            'remaining_leaves' => 'Remaining Leaves',
            'unpaid_leaves' => 'Unpaid Leaves',
            'asset_type' => 'Asset Type',
            'asset_name' => 'Asset Name',
            'serial_number' => 'Serial Number',
            'lent_to' => 'Lent To',
            'awards' => 'Awards',
            'active' => 'Active',
            'award_price' => 'Award Price',
            'assets_type' => 'Assets Type',
            'phone' => 'Phone',
            'probation_start_date' => 'Probation Start Date',
            'probation_end_date' => 'Probation End Date',
            'notice_start_date' => 'Notice Start Date',
            'notice_end_date' => 'Notice End Date',
            'duration' => 'Duration',
            'quick_add' => 'Quick Add',
            'add_field' => 'Add Field',
            'salary_details' => 'Salary Details',
            'employee_work_status' => 'Employee Work Status',
            'custom_data_fields' => 'Custom Data Fields',
            'value' => 'Value',
            'profile' => 'Profile',
            'sample_users_file' => 'Sample Users File',
        ],
        'role' => [
            'add' => 'Add New Role',
            'edit' => 'Edit Role',
            'created' => 'Role Created Successfully',
            'updated' => 'Role Updated Successfully',
            'deleted' => 'Role Deleted Successfully',
            'role_details' => 'Role Details',
            'delete_message' => 'Are you sure you want to delete this role?',
            'selected_delete_message' => 'Are you sure you want to delete selected role?',
            'display_name' => 'Display Name',
            'role_name' => 'Role Name',
            'description' => 'Description',
            'user_management' => 'User Management',
            'permissions' => 'Permissions',
            'search_permissions' => 'Search Permissions',
        ],
        'assigned_surve' => [
            'add' => 'Add New Assigned Survey',
            'edit' => 'Edit Assigned Survey',
            'created' => 'Assigned Survey Created Successfully',
            'updated' => 'Assigned Survey Updated Successfully',
            'deleted' => 'Assigned Survey Deleted Successfully',
            'assigned_survey_details' => 'Assigned Survey Details',
            'delete_message' => 'Are you sure you want to delete this Assigned Survey?',
            'selected_delete_message' => 'Are you sure you want to delete selected Assigned Survey?',
            'title' => 'Title',
            'publish_date' => 'Publish Date',
            'last_date' => 'Last Date',
            'submit_date' => 'Submit Date',
            'link' => 'Link',
            'start_date' => 'Start Date',
            'rating' => 'Rating',
            'assigned_info' => 'Assigned Info',
            'there_is_no_assigned_survey' => 'There is no assigned survey yet.',
            'no_active_assigned_survey' => 'There is no active assigned survey yet.',
            'no_expired_assigned_survey' => 'There is no expired assigned survey yet.',
        ],
        'form' => [
            'add' => 'Add New Form',
            'edit' => 'Edit Form',
            'created' => 'Form Created Successfully',
            'updated' => 'Form Updated Successfully',
            'deleted' => 'Form Deleted Successfully',
            'form_details' => 'Form Details',
            'delete_message' => 'Are you sure you want to delete this form?',
            'selected_delete_message' => 'Are you sure you want to delete selected form?',
            'name' => 'Name',
            'form_fields' => 'Form Fields',
            'description' => 'Description',
            'status' => 'Status',
            'add_form_field' => 'Add Form Field',
            'field_name' => 'Field Name',
            'field_type' => 'Field Type',
            'status_update' => 'Status Updated Successfully',
        ],
        'indicator' => [
            'add' => 'Add New Review Indicator',
            'edit' => 'Edit Review Indicator',
            'created' => 'Review Indicator Created Successfully',
            'updated' => 'Review Indicator Updated Successfully',
            'deleted' => 'Review Indicator Deleted Successfully',
            'indicator_details' => 'Review Indicator Details',
            'delete_message' => 'Are you sure you want to delete this review indicator?',
            'selected_delete_message' => 'Are you sure you want to delete selected review indicator?',
            'name' => 'Name',
            'fields' => 'Fields',
        ],
        'template' => [
            'add' => 'Add New Template',
            'edit' => 'Edit Template',
            'created' => 'Template Created Successfully',
            'updated' => 'Template Updated Successfully',
            'deleted' => 'Template Deleted Successfully',
            'template_details' => 'Template Details',
            'delete_message' => 'Are you sure you want to delete this template?',
            'selected_delete_message' => 'Are you sure you want to delete selected template?',
            'title' => 'Title',
            'template_fields' => 'Template Fields',
            'description' => 'Description',
            'available_keys' => 'Available Keys',
            'available_employee_keys' => 'Available Employee Keys',
            'available_other_keys' => 'Available Other Keys',
            'available_appreciation_keys' => 'Available Appreciation Keys',
        ],
        'generate' => [
            'add' => 'Add New Generate',
            'edit' => 'Edit Generate',
            'created' => 'Generate Created Successfully',
            'updated' => 'Generate Updated Successfully',
            'deleted' => 'Generate Deleted Successfully',
            'generate_details' => 'Generate Details',
            'delete_message' => 'Are you sure you want to delete this generate?',
            'selected_delete_message' => 'Are you sure you want to delete selected generate?',
            'title' => 'Title',
            'user_id' => 'Staff',
            'letter_head_template' => 'Letter Head Template',
            'description' => 'Description',
            'left_space' => 'Left Space',
            'right_space' => 'Right Space',
            'bottom_space' => 'Bottom Space',
            'top_space' => 'Top Space',
            'details' => 'Details',
            'generate_letter' => 'Generate Letter',
            'update_letter' => 'Update Letter',
            'created_date' => 'Created Date',
            'preview' => 'Preview',
            'download_header_footer' => 'Download (Header & Footer)',
            'print_header_footer' => 'Print (Header & Footer)',
            'created_at' => 'Created',
            'no_letter_heads' => 'There is no letter heads yet.'
        ],
        'warning' => [
            'add' => 'Add New Warning',
            'edit' => 'Edit Warning',
            'created' => 'Warning Created Successfully',
            'updated' => 'Warning Updated Successfully',
            'deleted' => 'Warning Deleted Successfully',
            'warning_details' => 'Warning Details',
            'delete_message' => 'Are you sure you want to delete this warning?',
            'selected_delete_message' => 'Are you sure you want to delete selected warning?',
            'user' => 'User',
            'title' => 'Title',
            'description' => 'Description',
            'warning_date' => 'Warning Date',
            'no_warnings' => 'There is no warnings yet.'
        ],
        'resignation' => [
            'add' => 'Add New Resignation',
            'edit' => 'Edit Resignation',
            'created' => 'Resignation Created Successfully',
            'updated' => 'Resignation Updated Successfully',
            'deleted' => 'Resignation Deleted Successfully',
            'resignation_details' => 'Resignation Details',
            'delete_message' => 'Are you sure you want to delete this resignation?',
            'selected_delete_message' => 'Are you sure you want to delete selected resignation?',
            'user' => 'User',
            'title' => 'Title',
            'resignation_date' => 'Resignation Date',
            'last_working_date' => 'Last Working Date',
            'status' => 'Status',
            'description' => 'Description',
            'reply_notes' => 'Reply Notes',
            'resignation_status_updated' => 'Resignation Status Updated Successfully',
            'update_resignation_status' => 'Update Resignation Status',
            'reply' => 'Reply',
            'no_resignations' => 'There is no resignations yet.',
            'no_pending_resignations' => 'There is no pending resignations yet.',
            'no_approved_resignations' => 'There is no approved resignations yet.',
            'no_rejected_resignations' => 'There is no rejected resignations yet.',
        ],
        'termination' => [
            'add' => 'Add New Termination',
            'edit' => 'Edit Termination',
            'created' => 'Termination Created Successfully',
            'updated' => 'Termination Updated Successfully',
            'deleted' => 'Termination Deleted Successfully',
            'termination_details' => 'Termination Details',
            'delete_message' => 'Are you sure you want to delete this termination?',
            'selected_delete_message' => 'Are you sure you want to delete selected termination?',
            'user' => 'User',
            'title' => 'Title',
            'notice_date' => 'Notice Date',
            'termination_date' => 'Termination Date',
            'description' => 'Description',
        ],
        'feedback' => [
            'add' => 'Add New Survey Form',
            'edit' => 'Edit Survey Form',
            'created' => 'Survey Form Created Successfully',
            'updated' => 'Survey Form Updated Successfully',
            'deleted' => 'Survey Form Deleted Successfully',
            'feedback_details' => 'Survey Form Details',
            'delete_message' => 'Are you sure you want to delete this survey form?',
            'selected_delete_message' => 'Are you sure you want to delete selected survey form?',
            'title' => 'Title',
            'form_id' => 'Form Fields',
            'description' => 'Description',
            'status' => 'Status',
            'visible_to' => 'Visible To',
            'user_id' => 'Employees',
            'Feedback_id' => 'Feedback',
            'all' => 'All',
            'select_employee' => 'Select Employees',
            'publish_date' => 'Publish Date',
            'add_form_field' => 'Add Form Field',
            'field_name' => 'Field Name',
            'field_type' => 'Field Type',
            'form' => 'Feedback Form',
            'feedback_form' => 'Generate Form',
            'answers' => 'Your Answer',
            'dates' => 'Assign Dates',
            'start_date' => 'Start Date',
            'last_date' => 'Last Date',
            'expired' => 'Expired',
            'active' => 'Active',
            'submit_date' => 'Submit Date',
            'replied' => 'Replied',
            'not_replied' => 'Not Replied',
            'indicator_fields' => 'Review Indicator Fields',
            'rating_updated' => 'Rating Updated Successfully',
            'rating' => 'Rating',
            'indicator_field' => 'Review Indicator Field',
            'survey_info' => 'Survey Info',
            'employee_details' => 'Employee Details',
            'submittion_date_expired' => 'Submission date is expired !',
            'all_employee' => 'All Employee',
            'employee' => 'Employee',
            'feedback_info' => 'Feedback Info',
            'selected_employees' => 'Selected Employees'
        ],
        'complaint' => [
            'add' => 'Add New Complaint',
            'edit' => 'Edit Complaint',
            'created' => 'Complaint Created Successfully',
            'updated' => 'Complaint Updated Successfully',
            'deleted' => 'Complaint Deleted Successfully',
            'complaint_details' => 'Complaint Details',
            'delete_message' => 'Are you sure you want to delete this complaint?',
            'selected_delete_message' => 'Are you sure you want to delete selected complaint?',
            'title' => 'Title',
            'date_time' => 'Date Time',
            'description' => 'Description',
            'status' => 'Status',
            'to_user_id' => 'To Staff',
            'pending' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'from_staff' => 'From Staff',
            'against_you' => 'Against You',
            'by_you' => 'By You',
            'proff_of_document' => 'Proff Of Document',
            'to_staff' => 'To Staff',
            'approved_message' => 'Are you sure you want to approved this complaint?',
            'approved_success' => 'Complaint Approved Successfully',
            'reply_notes' => 'Reply Notes',
            'update_complaint_status' => 'Update Complaint Status',
            'complaint_status_updated' => 'Complaint Status Updated Successfully',
            'reply' => 'Reply',
            'no_complaints' => 'There is no complaints yet.',
            'no_complaints_against_you' => 'There is no complaints against you yet.',
            'no_complaints_by_you' => 'There is no complaints by you yet.',
        ],
        'news' => [
            'add' => 'Add New News',
            'edit' => 'Edit News',
            'created' => 'News Created Successfully',
            'updated' => 'News Updated Successfully',
            'deleted' => 'News Deleted Successfully',
            'news_details' => 'News Details',
            'delete_message' => 'Are you sure you want to delete this news?',
            'selected_delete_message' => 'Are you sure you want to delete selected news?',
            'title' => 'Title',
            'News' => 'News',
            'description' => 'Description',
            'status' => 'Status',
            'visible_to_all' => 'Visible To All',
            'user_id' => 'Employees',
            'news_id' => 'News',
            'all' => 'All',
            'select_employee' => 'Select Employees',
            'publish' => 'Publish',
            'cancel' => 'Cancel',
            'confirm_message' => 'Are you sure want to publish this news?',
            'news_published' => 'News Published',
            'news_published_success' => 'The News is published sucessfully',
            'no_news' => 'No News Found',
        ],
        'location' => [
            'add' => 'Add New Location',
            'edit' => 'Edit Location',
            'created' => 'Location Created Successfully',
            'updated' => 'Location Updated Successfully',
            'deleted' => 'Location Deleted Successfully',
            'location_details' => 'Location Details',
            'delete_message' => 'Are you sure you want to delete this location?',
            'selected_delete_message' => 'Are you sure you want to delete selected location?',
            'name' => 'Name',
            'address' => 'Address',
        ],
        'asset_type' => [
            'add' => 'Add New Asset Type',
            'edit' => 'Edit Asset Type',
            'created' => 'Asset Type Created Successfully',
            'updated' => 'Asset Type Updated Successfully',
            'deleted' => 'Asset Type Deleted Successfully',
            'asset_type_details' => 'Asset Type Details',
            'delete_message' => 'Are you sure you want to delete this asset type?',
            'selected_delete_message' => 'Are you sure you want to delete selected asset type?',
            'name' => 'Name',
        ],
        'company' => [
            'add' => 'Add New Company',
            'edit' => 'Edit Company',
            'created' => 'Company Created Successfully',
            'updated' => 'Company Updated Successfully',
            'deleted' => 'Company Deleted Successfully',
            'currency_details' => 'Company Details',
            'delete_message' => 'Are you sure you want to delete this company?',
            'selected_delete_message' => 'Are you sure you want to delete selected company?',
            'name' => 'Company Name',
            'short_name' => 'Company Short Name',
            'email' => 'Company Email',
            'phone' => 'Company Phone',
            'address' => 'Company Address',
            'currency' => 'Currency',
            'logo' => 'Company Logo',
            'left_sidebar_theme' => 'Left Sidebar Theme',
            'dark' => 'Dark',
            'light' => 'Light',
            'dark_logo' => 'Dark Logo',
            'light_logo' => 'Light Logo',
            'small_dark_logo' => 'Small Dark Logo',
            'small_light_logo' => 'Small Light Logo',
            'primary_color' => 'Primary Color',
            'default_timezone' => 'Default Timezone',
            'date_format' => 'Date Format',
            'time_format' => 'Time Format',
            'auto_detect_timezone' => 'Auto Detect Timezone',
            'app_debug' => 'App Debug',
            'update_app_notification' => 'Update App Notitication',
            'login_image' => 'Login Image',
            'layout' => 'Layout',
            'rtl' => 'RTL',
            'ltr' => 'LTR',
            'shortcut_menu_Placement' => 'Add Menu Placement',
            'top_and_bottom' => 'Top & Bottom',
            'top_header' => 'Top Header',
            'bottom_corner' => 'Bottom Conrer',
            'shortcut_menu_setting' => 'Add Menu Settings',
            'menu_setting_updated' => 'Menu Setting Updated',
            'basic_details' => 'Basic Details',
            'details' => 'Details',
            'register_date' => 'Register Date',
            'total_users' => 'Total Users',
            'general_settings' => 'General Settings',
            'appearance' => 'Appearance',
            'preferences' => 'Preferences',
            'localization' => 'Localization',
            'advanced' => 'Advanced',
            'google_geo_coding_api_key' => 'Google Geocoding API KEY',
            'geo_coding_api' => 'Google Geocoding API'
        ],
        'currency' => [
            'add' => 'Add New Currency',
            'edit' => 'Edit Currency',
            'created' => 'Currency Created Successfully',
            'updated' => 'Currency Updated Successfully',
            'deleted' => 'Currency Deleted Successfully',
            'currency_details' => 'Currency Details',
            'delete_message' => 'Are you sure you want to delete this currency?',
            'selected_delete_message' => 'Are you sure you want to delete selected currency?',
            'name' => 'Currency Name',
            'symbol' => 'Currency Symbol',
            'position' => 'Currency Position',
            'front' => 'Front',
            'front_position_example' => 'Example : $100',
            'behind' => 'Behind',
            'behind_position_example' => 'Example : 100$',
            'code' => 'Currency Code',
        ],
        'asset' => [
            'add' => 'Add New Asset',
            'edit' => 'Edit Asset',
            'created' => 'Asset Created Successfully',
            'updated' => 'Asset Updated Successfully',
            'deleted' => 'Asset Deleted Successfully',
            'asset_details' => 'Asset Details',
            'delete_message' => 'Are you sure you want to delete this asset?',
            'selected_delete_message' => 'Are you sure you want to delete selected asset?',
            'name' => 'Asset Name',
            'image' => 'Image',
            'description' => 'Description',
            'status' => 'Status',
            'location_id' => 'Location',
            'serial_number' => 'Serial Number',
            'to_lend' => 'To Lend',
            'lent_to' => 'Lent To',
            'lend_date' => 'Lend Date',
            'return_date' => 'Return Date',
            'user_id' => 'User',
            'lend' => 'Asset Lent Successfully',
            'return' => 'Return',
            'asset_type_id' => 'Asset Type',
            'notes' => 'Notes',
            'actual_return_date' => 'Actual Return Date',
            'lend_by' => 'Lend By',
            'return_by' => 'Return By',
            'asset_history' => 'Asset History',
            'returned' => 'Asset returned Successfully !',
            'account_number' => 'Account Number',
            'purchase_date' => 'Purchase Date',
            'price' => 'Price',
            'transaction_details' => 'Transaction Details',
            'is_broken' => 'Is Broken?',
            'location' => 'Location',
            'broken_by' => 'Broken By',
            'no_assets' => 'There is no asset yet.',
            'no_broken_assets' => 'There is no broken asset yet.',
        ],
        'module' => [
            'name' => 'Module Name',
            'verified' => 'Verified',
            'verify_purchase_code' => 'Verify Purchase Code',
            'current_version' => 'Current Version',
            'latest_version' => 'Latest Version',
            'status' => 'Status',
            'installed_modules' => 'Installed Modules',
            'other_modules' => 'Other Modules',
            'module_status_updated' => 'Modules Status Updated',
            'downloading_completed' => 'Download Completed',
            'extract_zip_file' => 'Extract Zip File',
            'file_extracted' => 'Zip File Extracted',
        ],
        'update_app' => [
            'app_details' => 'App Details',
            'name' => 'Name',
            'value' => 'Value',
            'php_version' => 'PHP Version',
            'app_version' => 'App Version',
            'laravel_version' => 'Laravel Version',
            'mysql_version' => 'MySQL Version',
            'vue_version' => 'Vue Version',
            'update_app' => 'Update App',
            'update_now' => 'Update Now',
            'update_available' => 'Update Available',
            'verify_again' => 'Verify Again',
            'verify_failed' => 'Verification Failed',
            'verify_failed_message' => 'Your application is not registerd with us. Please verify it',
            'verified_with_other_domain' => 'Your purchase code is registerd with other doamin. Please verfiy your purhcase code',
        ],
        'langs' => [
            'add' => 'Add New Language',
            'edit' => 'Edit Language',
            'details' => 'Language Details',
            'created' => 'Language Created Successfully',
            'updated' => 'Language Updated Successfully',
            'deleted' => 'Language Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this language?',
            'selected_delete_message' => 'Are you sure you want to delete selected language?',
            'view_all_langs' => 'View All Languages',
            'status_updated' => 'Langugage status updated',
            'name' => 'Name',
            'key' => 'Key',
            'flag' => 'Flag',
            'enabled' => 'Enabled',
        ],
        'translations' => [
            'fetch_new_translations' => 'Fetch New Translations',
            'reload_translations' => 'Reload Translations',
            'reload_successfully' => 'Translations Reload Successfully',
            'fetched_successfully' => 'Translations Fetch Successfully',
            'import_translations' => 'Import Translations',
        ],
        'storage_settings' => [
            'updated' => 'Storage Settings Updated',
            'storage' => 'Storage',
            'local' => 'Local',
            'aws' => 'AWS S3 Storage',
            'aws_key' => 'AWS Key',
            'aws_secret' => 'AWS Secret',
            'aws_region' => 'AWS Region',
            'aws_bucket' => 'AWS Bucket',
        ],
        'staff_member' => [
            'add' => 'Add New Employee',
            'edit' => 'Edit Employee',
            'created' => 'Employee Created Successfully',
            'updated' => 'Employee Updated Successfully',
            'deleted' => 'Employee Deleted Successfully',
            'staff_member_details' => 'Employee Details',
            'staff_member' => 'Employee',
            'delete_message' => 'Are you sure you want to delete this employee?',
            'selected_delete_message' => 'Are you sure you want to delete selected employee?',
            'import_staff_members' => 'Import Employees',

        ],
        'expense_category' => [
            'add' => 'Add New Expense Category',
            'edit' => 'Edit Expense Category',
            'created' => 'Expense Category Created Successfully',
            'updated' => 'Expense Category Updated Successfully',
            'deleted' => 'Expense Category Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this expense category?',
            'selected_delete_message' => 'Are you sure you want to delete selected expense category?',
            'expense_category_details' => 'Expense Category Details',
            'name' => 'Expense Category Name',
            'description' => 'Description',
            'expense_for' => 'Expense For',
            'employee_specific' => 'Employee Specific',
            'company_specific' => 'Company Specific',
        ],
        'expense' => [
            'add' => 'Add New Expense',
            'edit' => 'Edit Expense',
            'created' => 'Expense Created Successfully',
            'updated' => 'Expense Updated Successfully',
            'deleted' => 'Expense Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this expense?',
            'selected_delete_message' => 'Are you sure you want to delete selected expense?',
            'details' => 'Expense Details',
            'warehouse' => 'Warehouse',
            'expense_category' => 'Expense Category',
            'date_time' => 'Date Time',
            'amount' => 'Amount',
            'bill' => 'Expense Bill',
            'user' => 'User',
            'created_by_user' => 'User',
            'notes' => 'Notes',
            'payee' => 'Payee',
            'account' => 'Account',
            'reference_number' => 'Reference Number',
            'employee_claims' => 'Employee Claims',
            'company_claims' => 'Company Claims',
            'expense_type' => 'Expense Type',
            'expense_details' => 'Expense Detials',
            'payment_date' => 'Payment Date',
            'status' => 'Status',
            'expense_details' => 'Expense Details',
            'transaction_type' => 'Transaction Type',
            'pending' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'update_expense_status' => 'Update Expense Status',
            'payment_status' => 'Payment Status',
            'right_now' => 'Right Now',
            'decuct_from_payroll' => 'Decuct From Payroll',
            'approve_reject' => 'Approve/Reject',
            'no_pending_expenses' => 'There is no pending expenses yet.',
            'no_approved_expenses' => 'There is no approved expenses yet.',
            'no_rejected_expenses' => 'There is no rejected expenses yet.',
            'expense_date' => 'Expense Date',
            'expense_records' => 'Expense Record',
            'expense_statement' => 'Expense Statement',
            'no_expense_data' => 'There is no expense record found.',
        ],
        'company_policy' => [
            'add' => 'Add New Company Policy',
            'edit' => 'Edit Company Policy',
            'created' => 'Company Policy Created Successfully',
            'updated' => 'Company Policy Updated Successfully',
            'deleted' => 'Company Policy Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this company policy?',
            'selected_delete_message' => 'Are you sure you want to delete selected company policy?',
            'location' => 'Location',
            'title' => 'Title',
            'policy_document' => 'Policy Document',
            'description' => 'Description',
            'company_policy_details' => 'Company Policy Details',
            'latest_compony_policy' => 'Latest Compony Policy',
            'method_type' => 'Method Type',
            'upload' => 'Upload File',
            'create' => 'Create File',
            'letter_description' => 'Letter Description',
            'no_company_policy' => 'There is no company policy yet.'
        ],
        'account' => [
            'add' => 'Add New Account',
            'edit' => 'Edit Account',
            'created' => 'Account Created Successfully',
            'updated' => 'Account Updated Successfully',
            'deleted' => 'Account Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this account?',
            'selected_delete_message' => 'Are you sure you want to delete selected account?',
            'name' => 'Name',
            'initial_balance' => 'Initial Balance',
            'account_number' => 'Account Number',
            'branch_code' => 'Branch Code',
            'branch_address' => 'Branch Address',
            'available_balance' => 'Available Balance',
            'type' => 'Transaction Type',
            'date' => 'Date',
            'asset' => 'Asset',
            'deposit' => 'Deposit',
            'payroll' => 'Payroll',
            'pre_payment' => 'Pre Payment',
            'expense' => 'Expense',
            'appreciation' => 'Appreciation',
            'amount' => 'Amount',
            'all' => 'All',
            'account_statement' => 'Account Statement',
            'transition' => 'Transition Types',
            'credit' => 'Credit',
            'debit' => 'Debit',
            'balance' => 'Balance',
            'opening_balance' => 'Opening Balance',
            'description' => 'Description',
            'transactions' => 'Transactions',
            'total_credit' => 'Total Credit Amount',
            'total_debit' => 'Total Debit Amount',
            'closing_balance' => 'Closing Balance',
            'statement_date' => 'Statement Date',
            'statement_period' => 'Statement Period',
        ],
        'employee_custom_field' => [
            'add' => 'Add New Employee Custom Fields',
            'edit' => 'Edit Employee Custom Fields',
            'created' => 'Employee Custom Fields Created Successfully',
            'updated' => 'Employee Custom Fields Updated Successfully',
            'deleted' => 'Employee Custom Fields Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this employee custom fields?',
            'selected_delete_message' => 'Are you sure you want to delete selected employee custom fields?',
            'name' => 'Name',
            'field_type_id' => 'Field Type',
            'is_required' => 'Is Required',
            'default_value' => 'Default Value',
            'text' => 'Text',
            'large_text' => 'Large Text',
            'file' => 'File',
            'date' => 'Date',
            'select' => 'Select',
            'add_employee_fields' => 'Add Employee Fields',
            'employee_field_name' => 'Employee Field Name',
            'type' => 'Type',
            'yes' => 'Yes',
            'no' => 'No',
            'employee_fields' => 'Employee Fields',
            'visible_to_employee' => 'Visible To Employee',
            'visible_to_employee_status' => 'Status Updated Successfully',
            'no_employee_custom_fields' => "There are no employee custom fields.",
            'no_data_found' => 'No Date Found'
        ],
        'payee' => [
            'add' => 'Add New Payee',
            'edit' => 'Edit Payee',
            'created' => 'Payee Created Successfully',
            'updated' => 'Payee Updated Successfully',
            'deleted' => 'Payee Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this payee?',
            'selected_delete_message' => 'Are you sure you want to delete selected payee?',
            'name' => 'Name',
            'phone_number' => 'Phone Number',
        ],
        'salary_group' => [
            'add' => 'Add New Salary Group',
            'edit' => 'Edit Salary Group',
            'created' => 'Salary Group Created Successfully',
            'updated' => 'Salary Group Updated Successfully',
            'deleted' => 'Salary Group Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this salary group?',
            'selected_delete_message' => 'Are you sure you want to delete selected salary group?',
            'name' => 'Name',
            'salary_component_id' => 'Salary Component',
            'user_id' => 'Users',
            'add_new_value' => 'Add New Salary Component',
            'salary_group_id' => 'Salary Group',
            'total_users' => 'Total Users',
            'validation_name' => 'Name field is required',
            'validation_type' => 'Type field is required',
            'validation_monthly' => 'Monthly field is required',
            'validation_value_type' => 'Value type field is required'
        ],
        'salary_component' => [
            'add' => 'Add New Salary Component',
            'edit' => 'Edit Salary Component',
            'created' => 'Salary Component Created Successfully',
            'updated' => 'Salary Component Updated Successfully',
            'deleted' => 'Salary Component Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this salary component?',
            'selected_delete_message' => 'Are you sure you want to delete selected salary component?',
            'name' => 'Name',
            'type' => 'Type',
            'value_type' => 'Value Type',
            'weekly' => 'Weekly',
            'bi_weekly' => 'Bi-weekly',
            'monthly' => 'Monthly',
            'semi_monthly' => 'Semi-monthly',
            'ctc_percent' => 'CTC Percent',
            'basic_percent' => 'Basic Percent',
            'fixed' => 'Fixed',
            'variable' => 'Variable',
            'earnings' => 'Earnings',
            'deductions' => 'Deductions',
            'value' => 'Value'
        ],
        'payer' => [
            'add' => 'Add New Payer',
            'edit' => 'Edit Payer',
            'created' => 'Payer Created Successfully',
            'updated' => 'Payer Updated Successfully',
            'deleted' => 'Payer Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this payer?',
            'selected_delete_message' => 'Are you sure you want to delete selected payer?',
            'name' => 'Name',
            'phone_number' => 'Phone Number',
        ],
        'deposit_category' => [
            'add' => 'Add New Deposit Category',
            'edit' => 'Edit Deposit Category',
            'created' => 'Deposit Category Created Successfully',
            'updated' => 'Deposit Category Updated Successfully',
            'deleted' => 'Deposit Category Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this deposit category?',
            'selected_delete_message' => 'Are you sure you want to delete selected deposit category?',
            'name' => 'Name',
        ],
        'deposit' => [
            'add' => 'Add New Deposit',
            'edit' => 'Edit Deposit',
            'created' => 'Deposit Created Successfully',
            'updated' => 'Deposit Updated Successfully',
            'deleted' => 'Deposit Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this deposit?',
            'selected_delete_message' => 'Are you sure you want to delete selected deposit?',
            'account' => 'Account',
            'payer' => 'Payer',
            'amount' => 'Amount',
            'date_time' => 'Date Time',
            'reference_number' => 'Reference Number',
            'file' => 'File',
            'notes' => 'Notes',
            'deposit_category' => 'Deposit Category',
            'deposit_details' => 'Deposit Details',
        ],
        'hrm_dashboard' => [
            'today_attendance' => 'Attendances',
            'current_ip_address' => 'Current IP Address',
            'current_time' => 'Current Time',
            'clock_in' => 'Clock In',
            'clocked_in' => 'Clocked In',
            'clock_out' => 'Clock Out',
            'clocked_out' => 'Clocked Out',
            'office_hours_expired' => 'Times Up: Office Hours Expired. Ensure Timely Clock-In and Clock-Out to Keep Attendance Records Accurate.',
            'pending_approvals' => 'Pending Approvals',
            'not_marked' => 'Not Marked',
            'present' => 'Present',
            'absent' => 'Absent',
            'today_is_holiday' => 'Today is holiday...',
            'you_are_on_leave' => 'You are on leave so you cannot clock-in... Enjoy your leave.',
            'self_clocking_is_disabled' => 'Self clocking is disabled by admin',
            'pending_leaves' => 'Leaves',
            'pending_expenses' => 'Expenses',
            'clock_in_out' => 'Clock-In/Out',
            'all_departments' => 'All Departments',
            'design' => 'Design',
            'today' => 'Today',
            'this_week' => 'This Week',
            'this_month' => 'This Month',
            'production' => 'Production',
            'view_all_attendance' => 'View All Attendance',
            'development' => 'Development',
            'view_all' => 'View All',
            'tomorrow' => 'Tomorrow',
            'no_of_employees_increased_by' => 'No of Employees Increased by',
            'birthdays' => 'Birthdays',
            'employees_by_department' => 'Employees By Department',
            'total_employee' => 'Total Employees',
            'view_all_employees' => 'View All Employees',
            'performance' => 'Performance',
            'send' => 'Send',
            'top_performer' => 'Top Performer',
            'your_operation_has_been_executed' => 'Your operation has been executed',
            'no_attendace_mark' => 'No attendance mark yet',
            'view_all_birthdays' => 'View all birthdays',
            'there_is_no_birthday' => 'There is no birthdays',
            'total_attendance' => 'Total Attendance',
            'present' => 'Present',
            'absent' => 'Absent',
            'not_marked' => 'Not Marked',
            'number_of_employees' => 'No of Employees',
            'employee_status' => 'Employee Status',
            'phone_number' => 'Phone Number',
            'email' => 'Email',
            'address' => 'Address',
            'joining_date' => 'Joining Date',
            'yesterday' => 'Yesterday',
            'this_year' => 'This Year',
            'year' => 'This Year',
            'weekend_holiday' => 'Weekend & Holidays',
            'weekend' => 'Weekend',
            'holiday' => 'Holiday',
            'there_is_no_anniversary' => 'There is no upcoming work anniversary',
            'there_is_no_weekends' => 'There is no weekends',
            'there_is_no_holidays' => 'There is no holidays',
            'there_is_no_pending_leaves' => 'There is no pending leaves',
            'there_is_no_pending_expenses' => 'There is no pending expenses',
            'warnings' => 'Warnings',
            'expenses' => 'Expenses',
            'complaints' => 'Complaints',
            'appreciations' => 'Appreciations',
            'assets_lent' => 'Assets Lent',
            'assign_survey' => 'Assign Survey',
            'employee_work_status' => 'Employee Work Status',
            'attendance_details' => 'Attendance Details',
            'lastWeek' => 'Last Week',
            'lastMonth' => 'Last Month',
            'lastYear' => 'Last Year',
            'there_are_no_increment_promotions' => 'There are no increment promotions',
            'start' => 'Start',
            'pause' => 'Pause',
            'reason' => 'Reason ',
            'reason_required' => 'Please enter reason',
            'modal_title' => 'Are you sure you want to clock out?',
            'modal_content' => "Once you clock out, you can't make changes for today.",
            'modal_text' => 'Yes, Clock Out',
            'add_reason' => 'Add Reason',
        ],
        'increment_promotion' => [
            'add' => 'Add New Increment/Promotion',
            'edit' => 'Edit Increment/Promotion',
            'created' => 'Increment/Promotion Created Successfully',
            'updated' => 'Increment/Promotion Updated Successfully',
            'deleted' => 'Increment/Promotion Deleted Successfully',
            'increment_and_promotion_details' => 'Increment/Promotion Details',
            'delete_message' => 'Are you sure you want to delete this increment/promotion?',
            'selected_delete_message' => 'Are you sure you want to delete selected increment/promotion?',
            'type' => 'Type',
            'date' => 'Date',
            'user_id' => 'User',
            'total_duration' => 'Total Duration',
            'description' => 'Description',
            'net_salary' => 'Annual CTC',
            'promoted_designation_id' => 'Promoted Designation',
            'current_designation_id' => 'Current Designation',
            'increment' => 'Increment',
            'promotion' => 'Promotion',
            'increment_promotion' => 'Increment/Promotion',
            'details' => "Details",
            'update_basic_salary' => 'Update Annual CTC',
            'update_designation' => 'Update Designation',
            'decrement_demotion' => 'Decrement/Demotion',
            'decrement' => 'Decrement',
            'basic_details' => 'Basic Details',
            'letter_head_details' => 'Letter Head Details',
            'letterhead_template_id' => 'Letter Head Template',
            'current_designation' => 'Current Designation',
            'promoted_designation' => 'Promoted Designation',
            'no_increments_promotions' => 'There is no increments/promotions',
        ],
        'holiday' => [
            'add' => 'Add New Holiday',
            'edit' => 'Edit Holiday',
            'created' => 'Holiday Created Successfully',
            'updated' => 'Holiday Updated Successfully',
            'deleted' => 'Holiday Deleted Successfully',
            'holiday_details' => 'Holiday Details',
            'delete_message' => 'Are you sure you want to delete this holiday?',
            'selected_delete_message' => 'Are you sure you want to delete selected holiday?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'year' => 'Year',
            'date' => 'Date',
            'mark_weekend_holiday' => 'Mark Weekend Holiday',
            'created_by' => 'Created By',
            'mark_holiday' => 'Holiday sucessfully updated',
            'from' => 'From',
            'to' => 'To',
            'month' => 'Month',
            'ocassion_name' => 'Ocassion Name',
            'mark_holiday' => 'Marked Holiday',
            'holiday_calendar' => 'Holiday Calendar',
            'import_holiday_from' => 'Import Holiday From',
            'import_holiday_to' => 'Import Holiday To',
            'the_name_field_is_required' => 'The name field is required',
            'the_date_field_is_required' => 'The date field is required',
            'view_all' => 'View All',
            'next_holiday' => 'Next Holiday',
            'is_half_day' => 'Is Half Day',
            'half_holiday' => 'Half Holiday',
            'award_id' => 'Award',
            'no_weekends' => 'There is no weekends',
            'no_holidays' => 'There is no holidays',
            'no_holiday_types' => 'There is no holiday types',
        ],
        'leave_type' => [
            'add' => 'Add New Leave Type',
            'edit' => 'Edit Leave Type',
            'created' => 'Leave Type Created Successfully',
            'updated' => 'Leave Type Updated Successfully',
            'deleted' => 'Leave Type Deleted Successfully',
            'leave_type_details' => 'LeaveType Details',
            'delete_message' => 'Are you sure you want to delete this leave type?',
            'selected_delete_message' => 'Are you sure you want to delete selected leave type?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'is_paid' => 'Is Paid',
            'total_leaves' => 'Total Leaves',
            'leave_interval_count' => 'Leave Interval Count',
            'max_leaves_per_month' => 'Max Leaves Per Month',
            'same_for_all' => 'Same For All',
            'employee_specific' => 'Employee Specific',
            'count_type' => 'Count Type',
            'employee_specific_leave_count' => 'Employee Specific Leave Count',
            'user_id' => 'User',
            'add_employees' => 'Add Employees',
            'edit_count' => 'Edit Count',
            'user_required' => 'User is required',
            'counts_required' => 'Total Count is required',
            'total_count' => 'Total Count',
        ],
        'employee_work_status' => [
            'add' => 'Add New Employee Work Status',
            'edit' => 'Edit Employee Work Status',
            'created' => 'Employee Work Status Created Successfully',
            'updated' => 'Employee Work Status Updated Successfully',
            'deleted' => 'Employee Work Status Deleted Successfully',
            'leave_type_details' => 'LeaveType Details',
            'delete_message' => 'Are you sure you want to delete this employee work status?',
            'selected_delete_message' => 'Are you sure you want to delete selected employee work status?',
            'name' => 'Name',
            'fulltime' => 'Fulltime',
            'contract' => 'Contract',
            'probation' => 'Probation',
            'work_from_home' => 'Work From Home'
        ],
        'leave' => [
            'add' => 'Add New Leave',
            'edit' => 'Edit Leave',
            'created' => 'Leave Created Successfully',
            'updated' => 'Leave Updated Successfully',
            'deleted' => 'Leave Deleted Successfully',
            'leave_details' => 'Leave Details',
            'delete_message' => 'Are you sure you want to delete this leave?',
            'selected_delete_message' => 'Are you sure you want to delete selected leave?',
            'display_name' => 'Display Name',
            'user_id' => 'User',
            'leave_type' => 'Leave Type',
            'is_paid' => 'Is Paid',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'is_half_day' => 'Is Half Day',
            'reason' => 'Reason',
            'file' => 'File',
            'status' => 'Status',
            'bill' => 'Bill',
            'date' => 'Date',
            'user' => 'User',
            'leave_status' => 'Leave Status',
            'department' => 'Department',
            'employees' => 'Employees',
            'mark_attendance' => 'Mark Attendance By',
            'clock_out' => 'Clock Out',
            'clock_in' => 'Clock In',
            'late' => 'Late',
            'half_day' => 'Half Day',
            'multiple_date' => 'You can select multiple dates',
            'clock_in_month' => 'Clock in Month',
            'attendance_overwrite' => 'Attendance Overwrite',
            'add_multiple' => 'Add Multiple Attendance',
            'approved_message' => 'Are you sure you want to Approved this leave?',
            'approve_reject' => 'Approve/Reject',
            'total_leaves' => 'Total Leaves',
            'absent' => 'Absent',
            'leave_details' => 'Leave Details',
            'worked_days' => 'Worked Days',
            'unpaid' => 'Unpaid Leaves',
            'paid' => 'Paid Leaves',
            'apply_new_leave' => 'Apply New Leave',
            'total_attendance' => 'Total Attendance',
            'present' => 'Present',
            'leaves' => 'Leaves',
            'late_attendance' => 'Late Attendance',
            'half_day' => 'Half Day',
            'half_leave' => 'Half Leave For',
            'total_leaves' => 'Total Leaves',
            'total_days' => 'Total Days',
            'days' => 'Day(s)',
            'end_data_required' => 'End date is required',
            'no_leaves' => 'There is no leaves yet.',
            'no_pending_leaves' => 'There is no pending leaves',
            'no_approved_leaves' => 'There is no approved leaves',
            'no_rejected_leaves' => 'There is no rejected leaves',
            'no_remaining_leaves' => 'There is no remaining leaves',
            'remaining_leaves' => 'Remaining Leaves',
            'leave_month' => 'Leave Month',
            'counts' => 'Counts',
        ],
        'award' => [
            'add' => 'Add New Award',
            'edit' => 'Edit Award',
            'created' => 'Award Created Successfully',
            'updated' => 'Award Updated Successfully',
            'deleted' => 'Award Deleted Successfully',
            'award_details' => 'Award Details',
            'delete_message' => 'Are you sure you want to delete this award?',
            'name' => 'Name',
            'active' => 'Active',
            'description' => 'Description',
            'award_price' => 'Award Price',
        ],
        'appreciation' => [
            'add' => 'Add New Appreciation',
            'edit' => 'Edit Appreciation',
            'created' => 'Appreciation Created Successfully',
            'updated' => 'Appreciation Updated Successfully',
            'deleted' => 'Appreciation Deleted Successfully',
            'appreciation_details' => 'Appreciation Details',
            'delete_message' => 'Are you sure you want to delete this appreciation?',
            'date' => 'Date',
            'description' => 'Description',
            'user' => 'User',
            'award' => 'Award',
            'price_amount' => 'Price Amount',
            'price_given' => 'Price Given',
            'add_price_given' => 'Add Price Given',
            'price_given_placeholder' => 'Holiday Vouchar, Movie Tickets etc...',
            'profile_image' => 'Profile Image',
            'letterhead_template' => 'Letterhead Template',
            'generates' => 'Generates',
            'account_number' => 'Account Number',
            'appreciation_details' => 'Appreciation Details',
            'letterhead_title' => 'Letterhead Title',
            'appreciations_count' => 'Appreciation Count',
            'no_appreciations' => 'There is no appreciations yet.',
            'appreciation_letter' => 'Appreciation Letter'
        ],
        'payroll' => [
            'add' => 'Add New Payroll',
            'edit' => 'Edit Payroll',
            'created' => 'Payroll Created Successfully',
            'updated' => 'Payroll Updated Successfully',
            'deleted' => 'Payroll Deleted Successfully',
            'payroll_details' => 'Payroll Details',
            'delete_message' => 'Are you sure you want to delete this payroll?',
            'month' => 'Month',
            'year' => 'Year',
            'user_id' => 'User',
            'net_salary' => 'Net Salary',
            'status' => 'Status',
            'payment_date' => 'Payment Date',
            'generate' => 'Generate',
            'generated' => 'Generated',
            'regenerate' => 'Regenerate',
            'regenerated' => 'Regenerated',
            'bonus' => 'Bonus',
            'earning' => 'Earning',
            'amount' => 'Amount',
            'add_earning' => 'Add Earning',
            'deduction' => 'Deduction',
            'total_days' => 'Total Days',
            'working_days' => 'Working Days',
            'present_days' => 'Present Days',
            'total_office_time' => 'Total Office Time',
            'total_worked_time' => 'Total Worked Time',
            'half_days' => 'Half Days',
            'late_days' => 'Late Days',
            'paid_leaves' => 'Paid Leaves',
            'unpaid_leaves' => 'Unpaid Leaves',
            'holiday_count' => 'Holiday Count',
            'leaves' => 'Leaves',
            'holiday' => 'Holiday',
            'summary' => 'Summary',
            'pre_payment_deduction' => 'Pre Payment Deduction',
            'salary_component' => 'Salary Component',
            'expense_amount' => 'Expense Amount',
            'basic_salary' => 'Basic Salary',
            'salary_amount' => 'Salary Amount',
            'paid' => 'Paid',
            'generated' => 'Generated',
            'payroll_status' => 'Status',
            'date' => 'Date',
            'status_generated' => 'Status Updated Sucessfully',
            'setup_basic_salary_to_generate_payroll' => 'If you want to generate payroll for an employee then first setup basic salary for that employee.',
            'basic_salary_setup' => 'Basic Salary Setup',
            'account' => 'Account',
            'selected_delete_message' => 'Are you sure you want to delete selected Payroll?',
            'adds' => 'Add',
            'add_additional_earnings' => 'Add Additional Earnings',
            'special_allowances' => 'Special Allowances',
            'earnings' => 'Earnings',
            'deductions' => 'Deductions',
            'monthly_value' => 'Monthly Value',
            'additional_earnings' => 'Additional Earnings',
            'pre_payment' => 'Pre Payment',
            'leave_deductions' => 'Leave Deduction',
            'gross_earnings' => 'Gross Earnings',
            'total_deductions' => 'Total Deductions',
            'reimbursements' => 'Reimbursements',
            'payroll_status' => 'Payroll Status',
            'expense_claim' => 'Expense Claim',
            'payroll_slip' => 'Payroll Slip',
            'name' => 'Name',
            'department' => 'Department',
            'designation' => 'Designation',
            'employee_id' => 'Employee Id',
            'salary_slip' => 'Salary Slip',
            'joining_date' => 'Joining Date',
            'pay_slip_for_duration' => 'Pay Slip For Duration',
            'year_not_available' => 'Year Not Available',
            'special_allowances_error' => 'Special Allowances cannot be negative',
            'special_allowances_calculation' => 'Your calculation is wrong. Special Allowances cannot be negative.',
            'view_salary' => 'View Salary',
            'no_payrolls' => 'There is no payrolls yet.',
        ],
        'pre_payment' => [
            'add' => 'Add New Pre Payment',
            'edit' => 'Edit Pre Payment',
            'created' => 'Pre Payment Created Successfully',
            'updated' => 'Pre Payment Updated Successfully',
            'deleted' => 'Pre Payment Deleted Successfully',
            'pre_payment_details' => 'Pre Payment Details',
            'delete_message' => 'Are you sure you want to delete this Pre Payment?',
            'selected_delete_message' => 'Are you sure you want to delete selected Pre Payment?',
            'user_id' => 'User',
            'date_time' => 'Date',
            'amount' => 'Amount',
            'notes' => 'Notes',
            'month' => 'Month',
            'deduct_from_payroll' => 'Deduct From Payroll',
            'payroll_month' => 'Payroll Month',
            'payroll_year' => 'Payroll Year',
            'deduct_from_payroll' => 'Deduct From Payroll',
            'on_given_payment_month' => 'On Given Payment Month',
            'another_month' => 'Another Month',
            'deduct_month' => 'Deduct Month',
            'deduct_account_number' => 'Deduct Account Number',
            'pre_payment_details' => 'Pre Payment Details',
            'no_pre_payments' => 'There is no pre payments yet.',
        ],
        'pdf_font' => [
            'add' => 'Add New Pdf Font',
            'edit' => 'Edit Pdf Font',
            'created' => 'Pdf Font Created Successfully',
            'updated' => 'Pdf Font Updated Successfully',
            'deleted' => 'Pdf Font Deleted Successfully',
            'appreciation_details' => 'Pdf Font Details',
            'delete_message' => 'Are you sure you want to delete this pdf font?',
            'name' => 'Name',
            'file' => 'File (.ttf)',
            'user_kashida' => 'User Kashida',
            'use_otl' => 'Use Otl',
            'pdf_settings' => 'Pdf Settings',
            'use_custom_font' => 'Use Custom Font',
            'current' => 'Current',
            'font_settings' => 'Font Settings',
            'appearance' => 'Appearance',
            'spacing' => 'Spacing',
            'pdf_font_size' => 'Pdf Font Size',
            "holiday_pdf" => "Holiday Pdf",
            'generate_pdf' => 'Generate Pdf',
        ],
        'attendance' => [
            'add' => 'Add New Attendance',
            'edit' => 'Edit Attendance',
            'created' => 'Attendance Created Successfully',
            'updated' => 'Attendance Updated Successfully',
            'deleted' => 'Attendance Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this attendance?',
            'selected_delete_message' => 'Are you sure you want to delete selected attendance?',
            'month' => 'Month',
            'year' => 'Year',
            'user_id' => 'Employees',
            'name' => 'Employees',
            'present' => 'Present',
            'present_days' => 'Present Days',
            'working_days' => 'Working Days',
            'total_office_time' => 'Total Office Time',
            'half_day' => 'Half Days',
            'absent' => 'Absent',
            'holiday' => 'Holiday',
            'date' => 'Date',
            'on_leave' => 'On Leave',
            'status' => 'Status',
            'clock_in' => 'Clock In',
            'clock_out' => 'Clock Out',
            'clocked_time' => 'Clocked Time',
            'other_details' => 'Other Details',
            'clock_in_ip' => 'Clock-In IP',
            'clock_out_ip' => 'Clock-Out IP',
            'hours' => 'hrs',
            'minutes' => 'mins',
            'late' => 'Late',
            'not_marked' => 'Not Marked',
            'total_office_time' => 'Total Office Time',
            'total_worked_time' => 'Total Worked Time',
            'present_working_days' => 'Present / Working Days',
            'clock_in_date_time' => 'Clock In Time',
            'clock_out_date_time' => 'Clock Out Time',
            'clock_in_ip_address' => 'Clock In IP Address',
            'clock_out_ip_address' => 'Clock Out IP Address',
            'days' => 'Days',
            'total_duration' => 'Total Duration',
            'is_late' => 'Is Late',
            'admin' => 'Admin',
            'is_half_day' => 'Is Half Day',
            'leave_type' => 'Leave Type',
            'user' => 'Users',
            'half_days' => 'Half Days',
            'reason' => 'Reason',
            'punch_in_at' => 'Punch In at',
            'punch_out' => 'Punch Out',
            'production' => 'Production',
            'half_holiday' => 'Half Holiday',
            'start_time' => 'Start Time',
            'end_time' => 'End Time',
            'duration' => 'Duration',
            'notes' => 'Notes',
            'paused' => 'Paused',
            'started' => 'Started',
            'break_history' => 'Break History',
            'work_summary' => 'Work Summary',
            'total_work_hours' => 'Total Work Hours',
            'effective_work_time' => 'Effective Work Time',
            'productivity_rate' => 'Productivity Rate',
            'break_summary' => 'Break Summary',
            'total_break_time' => 'Total Break Time',
            'total_breaks' => 'Total Breaks',
            'avg_break_duration' => 'Avg. Break Duration',
            'break_details' => 'Break Details',
            'location_access_required' => 'Location Access Required',
            'allow_location_access_to_mark_attendance' => '"Please allow location access to mark attendance."',
            'location' => 'Location',
            'location_details' => 'Location Details',
            'custom_map' => 'Custom Map',
            'google_map' => 'Google Map',
            'loading_map' => 'Loading Map...',
            'location_not_available' => 'Location not available.',
            'clock_in_location' => 'Clock-in Location',
            'clock_out_location' => 'Clock-out Location',
            'clock_in_details' => 'Clock-in Details',
            'clock_out_details' => 'Clock-out Details',
            'browser' => 'Browser',
            'platform' => 'Platform',
            'device_type' => 'Device Type',
            'user_agent' => 'User Agent',
            'latitude' => 'latitude',
            'longitude' => 'longitude',
            'name' => 'Name',
            'upcoming' => 'Upcoming',
            'no_attendance_records' => 'No Attendance Records',
            'import_attendance' => 'Import Attendance',
            'mark_attendance_by' => 'Mark Attendance By',
            'mark_attendance' => 'Mark Attendance',
            'bulk_attendance' => 'Bulk Attendance',
            'employees' => 'Employees',
            'geo_code_api_key_message' => 'To view location name set Google Geocoding api key from Company Settings => Google Geocoding API',
            'location_address' => 'Location Address',
            'attendance_statement' => 'Attendance Statement',
            'employee_number' => 'Employee Id',
            'clock_in_coordinates' => 'Clock In Coordinates',
            'clock_out_coordinates' => 'Clock Out Coordinates',
            'no_attendance_data' => 'There is no attendance record found.',
        ],
        'basic_salary' => [
            'add' => 'Add New Basic Salary',
            'edit' => 'Edit Basic Salary',
            'created' => 'Basic Salary Created Successfully',
            'updated' => 'Basic Salary Updated Successfully',
            'deleted' => 'Basic Salary Deleted Successfully',
            'basic_salary_details' => 'Basic Salary Details',
            'delete_message' => 'Are you sure you want to delete this basic salary?',
            'user' => 'User',
            'active' => 'Active',
            'basic_salary' => 'Basic Salary',
            'name' => 'Name',
            'salary_group' => 'Salary Group',
            'employee_salary_group' => 'Employee Salary Group',
            'fixed' => 'Fixed',
            '%_of_ctc' => '% of CTC',
            'annual_ctc' => 'Annual CTC',
            'cost_to_company_value_for_this_year' => '(Cost to company value for the whole year.)',
            'monthly_amount' => 'Monthly Amount',
            'annual_amount' => 'Annual Amount',
            'calculation_type' => 'Calculation Type',
            'earnings' => 'Earnings',
            'annual_CTC_sum_of_all_other_components' => '(Annual CTC - Sum of all other components)',
            'special_allowances' => 'Special Allowances',
            'cost_to_company' => 'Cost To Company',
            'employee_salary' => 'Employee Salary',
            'salary_component' => 'Salary Component',
            'ctc' => 'CTC',
            'ctc_value' => 'CTC Value',
            'deductions' => 'Deductions',
            'total_deductions' => 'Total Deductions',
        ],
        'hrm_settings' => [
            'updated' => 'HRM Setting Updated Successfully',
            'leave_start_month' => 'Leave Start Month',
            'late_mark_after' => 'Late Mark After',
            'clock_in_time' => 'Clock In Time',
            'clock_out_time' => 'Clock Out Time',
            'self_clocking' => 'Self Clocking',
            'allowed_ip_address' => 'Allowed Ip Address',
            'early_clock_in_time' => 'Early Clock In Time',
            'allow_clock_out_till' => 'Allow Clock Out till',
            'attendance_settings' => 'Attendance Settings',
            'front_job_details_settings' => 'Front Job Details Settings',
            'self_letter_head_settings' => 'Self Letter Head Settings',
            'letterhead_header_color' => 'Letterhead Header Color',
            'letterhead_show_company_name' => 'Letterhead Show Company Name',
            'letterhead_show_company_email' => 'Letterhead Show Company Email',
            'letterhead_show_company_phone' => 'Letterhead Show Company Phone',
            'letterhead_show_company_address' => 'Letterhead Show Company Address',
            'show_letterhead_footer' => 'Show Letterhead Footer On',
            'show_letterhead_footer_on_other_then_first_page' => 'Show Letterhead Footer On Other Then First Page',
            'show_letterhead_header' => 'Show Letterhead Header On',
            'all_pages' => 'All Pages',
            'first_page' => 'First Page',
            'none' => 'None',
            'employee_id_prefix_setting' => 'Employee Id Prefix Setting',
            'employee_id_prefix' => 'Employee Id Prefix',
            'employee_id_start' => 'Employee Id Start',
            'employee_id_digits' => 'Employee Id Digits',
            'letterhead_left_space' => 'Letterhead Left Space',
            'letterhead_right_space' => 'Letterhead Right Space',
            'letterhead_top_space' => 'Letterhead Top Space',
            'letterhead_bottom_space' => 'Letterhead Bottom Space',
            'holiday_pdf_font_size' => 'Holiday Pdf Font Size',
            'holiday_pdf_line_height' => 'Holiday Pdf Line Height',
            'generate_pdf_font_size' => 'Generate Pdf Font Size',
            'generate_pdf_line_height' => 'Generate Pdf Line Height',
            'letterhead_title_show_in_pdf' => 'Letterhead Title Show In Pdf',
            'capture_location' => 'Capture Location',
            'export_pdf' => 'Export Pdf',
            'export_pdf_font_size' => 'Export Pdf Font Size',
            'export_pdf_line_height' => 'Export Pdf Line Height',
            'letterhead_spacing' => 'Letterhead Spacing',
            'export_spacing' => 'Export Pdf Spacing',
            'export_pdf_right_space' => 'Export Right Space',
            'export_pdf_left_space' => 'Export Left Space',
            'export_pdf_top_space' => 'Export Top Space',
            'export_pdf_bottom_space' => 'Export Bottom Space',
        ],
        'shift' => [
            'add' => 'Add New Shift',
            'edit' => 'Edit Shift',
            'created' => 'Shift Created Successfully',
            'updated' => 'Shift Updated Successfully',
            'deleted' => 'Shift Deleted Successfully',
            'shift_details' => 'Shift Details',
            'delete_message' => 'Are you sure you want to delete this shift?',
            'selected_delete_message' => 'Are you sure you want to delete selected shift?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'clock_in_time' => 'Clock In Time',
            'clock_out_time' => 'Clock Out Time',
            'late_mark_after' => 'Late Mark After',
            'self_clocking' => 'Self Clocking',
            'allowed_ip_address' => 'Allowed IP Address',
            'add_new_ip_address' => 'Add New IP Address',
            'allow_clock_out_till' => 'Allow Clock Out Till',
            'early_clock_in_time' => 'Early Clock In Time',
            'total_employee' => 'Total Employee',
            'capture_location' => 'Capture Location',
        ],
        'designation' => [
            'add' => 'Add New Designation',
            'edit' => 'Edit Designation',
            'created' => 'Designation Created Successfully',
            'updated' => 'Designation Updated Successfully',
            'deleted' => 'Designation Deleted Successfully',
            'designation_details' => 'Designation Details',
            'delete_message' => 'Are you sure you want to delete this designation?',
            'selected_delete_message' => 'Are you sure you want to delete selected designation?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'total_employee' => 'Total Employee'
        ],
        'department' => [
            'add' => 'Add New Department',
            'edit' => 'Edit Department',
            'created' => 'Department Created Successfully',
            'updated' => 'Department Updated Successfully',
            'deleted' => 'Department Deleted Successfully',
            'department_details' => 'Department Details',
            'delete_message' => 'Are you sure you want to delete this department?',
            'selected_delete_message' => 'Are you sure you want to delete selected department?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'user_id' => 'User',
            'shift_id' => 'Shift',
            'total_employee' => 'Total Employee'
        ],
        'email_template' => [
            'edit' => 'Edit Email Template',
            'updated' => 'Department Updated Successfully',
            'name' => 'Name',
            'subject' => 'Email Subject',
            'body' => 'Email Body',
            'type' => 'Type',
            'available_variable' => 'Available Variables',
        ],
        'mail_settings' => [
            'updated' => 'Mail Settings Updated',
            'mail_driver' => 'Mail Driver',
            'none' => 'None',
            'mail' => 'Mail',
            'smtp' => 'SMTP',
            'from_name' => 'Mail From Name',
            'from_email' => 'Mail From Email',
            'host' => 'Host',
            'port' => 'Port',
            'encryption' => 'Encryption',
            'username' => 'Username',
            'password' => 'Password',
            'send_test_mail' => 'Send Test Mail',
            'send_mail_setting_saved' => 'Send mail setting saved',
            'enable_mail_queue' => 'Enable Mail Queue',
            'send_mail_for' => 'Send Mail To',
            'email' => 'Email address for which you want to send test mail',
            'test_mail_sent_successfully' => 'Test mail sent successfully',
            'notificaiton_will_be_sent_to_company' => 'Notification will be sent to company email',
            'notificaiton_will_be_sent_to_employee' => 'Notification will be sent to employee email',
            'company' => 'Company',
            'employee' => 'Employee',
            'on_welcome_mail' => 'Employee Welcome Mail',
            'on_asset_lent' => 'On Asset Lent',
            'on_asset_return' => 'On Asset Retrun',
            'on_appreciation' => 'On Appreciation',
            'on_leave_approve' => 'On Leave Approve',
            'on_leave_reject' => 'On Leave Reject',
            'on_news_published' => 'On News Published',
            'on_payroll_paid' => 'On Payroll Paid',
            'on_warning' => 'On Warning',
            'on_terminations' => 'On Terminations',
            'on_resignation_approve' => 'On Resignation Approve',
            'on_resignation_reject' => 'On Resignation Reject',
            'on_complaint_approve' => 'On Complaint Approve',
            'on_complaint_reject' => 'On Complaint Reject',
            'on_expense_approve' => 'On Expense Approve',
            'on_expense_reject' => 'On Expense Reject',
            'on_survey_forms_assign' => 'On Survey Forms Assign',
            'on_survey_forms_rating' => 'On Survey Forms Rating',
            'on_employee_leave_apply' => 'On Employee Leave Apply',
            'on_employee_clock_in' => 'On Employee Clock In',
            'on_employee_clock_out' => 'On Employee Clock Out',
            'on_employee_resignation_apply' => 'On Employee Resignation Apply',
            'on_employee_complaint_apply' => 'On Employee Complaint Apply',
            'on_employee_expense_apply' => 'On Employee Expense Apply',
            'on_employee_survey_submit' => 'On Employee Survey Submit',
        ],
        'database_backup' => [
            'file' => 'File',
            'file_size' => 'File Size',
            'generate_backup' => 'Generate Backup',
            'delete_backup' => 'Delete Backup',
            'backup_generated_successfully' => 'Backup Generated Successfully',
            'are_you_sure_generate_backup' => 'Are you sure you want to generate database backup?',
            'are_you_sure_delete_backup' => 'Are you sure you want to delete this database backup?',
            'backup_locaion_is' => 'All generated database file will be stored in storage/app/public/backup folder. ',
            'settings' => 'Command Settings',
            'backup_command_setting' => 'Backup Command Settings',
            'mysqldump_command_path' => 'mysqldump command path',
            'command_updated' => 'Command updated successfully',
            'window_command_path' => 'If you use XAMPP then it will be => C:\xampp\mysql\bin\mysqldump.exe',
            'laragon_command_path' => 'If you use Laragon then it will be => C:\laragon\bin\mysql\mysql-5.7.24-winx64\bin\mysqldump.exe',
            'linux_command_path' => 'If you are on ubuntu or mac then run following command and enter output here => which mysqldump',
            'put_dump_path_command_on_env_file' => 'Find your MySQL dump path from below and then add it to the DUMP_PATH inside .env file',
        ],
        'messages' => [
            'somehing_went_wrong' => 'Something went wrong. Please contact to administrator.',
            'verify_success' => 'Successfully verified. Redirect to app...',
            'login_success' => 'Successfully login. Redirect to app...',
            'login_success_dashboard' => 'Successfully logged into app.',
            'click_here_to_find_purchase_code' => 'Click here to find your purchase code',
            'verification_successfull' => 'Verification successfully',
            'other_domain_linked' => 'Other domain linked',
            'other_domain_linked_with_purchase_code' => 'Other domain is already linked with your purchase code. Please enter your purchase code for more details...',
            'first_verify_module_message' => 'To enable please \n verify this module',
            'are_you_sure_install_message' => 'Are you sure you want to install?',
            'downloading_started_message' => 'Downloading started. Please wait ...',
            'file_extracting_message' => 'File extracteding. Please wait ...',
            'installation_success' => 'Installation successfully. Click here to reload page...',
            'are_you_sure_update_message' => 'Are you sure you want to update? Please take backup before update.',
            'stmp_success_message' => 'Your SMTP settings are correct..',
            'stmp_error_message' => 'Your SMTP settings are incorrect. Please update it to send mails',
            'uploading_failed' => 'Uploading failed',
            'loading_app_message' => 'Please wait... we are preparing something amazing for you',
            'fetching_product_details' => 'We are fetching product details. Please wait...',
            'product_is_upto_date' => 'You are on the latest version of app.',
            'new_app_version_avaialbe' => 'New app version {0} is available. Please update to get latest version.',
            'not_able_to_edit_order' => 'Only order status editable, other fields can not be editable becuase this order linked to some payments. Delete those payment(s) and try again.',
            'click_here_to_download_sample_file' => 'Click here to download sample csv file',
            'imported_successfully' => 'Imported Successfully',
            'company_admin_password_message' => 'Admin will login using this password. (Leave blank to keep current password)',
            'email_setting_not_configured' => 'Email setting not configured',
            'please_configure_email_settings' => 'Please configure your email settings to send emails. Click Here to configure email settings.',
        ],
        'popover' => [
            'auto_detect_timezone' => 'Allow auto detect timezone from browser for currently logged in user.',
            'click_here_to_copy_credentials' => 'Click here to copy {0} credentials',
        ],
        'topbar_add_button' => [
            'add_staff_member' => 'Add Employee',
            'add_currency' => 'Add Currency',
            'add_language' => 'Add Language',
            'add_role' => 'Add Role',
            'add_departments' => 'Add Departments',
            'add_designations' => 'Add Designations',
            'add_shifts' => 'Add Shipts',
            'add_assets' => 'Add Assets',
            'add_holidays' => 'Add Holidays',
            'add_appreciations' => 'Add Appreciations',
            'add_awards' => 'Add Awards',
            'add_leaves' => 'Add Leaves',
            'add_attendance' => 'Add Attendance',
            'add_news' => 'Add News',
            'add_pre_payments' => 'Add Pre Payments',
            'add_increment_promotions' => 'Add Increment/Promotions',
            'add_company_policies' => 'Add Company Policies',
            'add_job_questions' => 'Add Job Questions',
            'add_openings' => 'Add Openings',
            'add_applications' => 'Add Applications',
            'add_warnings' => 'Add Warnings',
            'add_resignations' => 'Add Resignations',
            'add_terminations' => 'Add Terminations',
            'add_complaints' => 'Add Complaints',
            'add_templates' => 'Add Templates',
            'add_generates' => 'Add Generate',
            'add_indicators' => 'Add Indicators',
            'add_feedbacks' => 'Add Feedbacks',
            'add_accounts' => 'Add Accounts',
            'add_payees' => 'Add Payees',
            'add_payers' => 'Add Payers',
            'add_deposits' => 'Add Deposits',
            'add_deposit_categories' => 'Add Deposit Categories',
            'add_expenses' => 'Add Expenses',
            'add_expense_categories' => 'Add Expense Categories',
            'add_forms' => 'Add forms',
            'add_payrolls' => 'Add Payroll'
        ],
    ];

    public static $eStoreTranslations = [];

    public static function getTranslationArray($moduleName)
    {
        if ($moduleName == 'Estore') {
            return self::$eStoreTranslations;
        } else if ($moduleName == 'Superadmin') {
            return \App\SuperAdmin\Classes\SuperAdminLangTrans::$mainTranslations;
        }

        return self::$mainTranslations;
    }

    public static function seedTranslations($moduleName = '')
    {
        $allLangs = Lang::all();

        $translations = self::getTranslationArray($moduleName);

        foreach ($translations as $group => $translation) {
            foreach ($translation as $transKey => $transValue) {

                foreach ($allLangs as $allLang) {
                    $translationCount = Translation::where('lang_id', $allLang->id)
                        ->where('group', $group)
                        ->where('key', $transKey)
                        ->count();

                    if ($translationCount == 0) {
                        $newTranslation = new Translation();
                        $newTranslation->lang_id = $allLang->id;
                        $newTranslation->group = $group;
                        $newTranslation->key = $transKey;
                        $newTranslation->value = $transValue;
                        $newTranslation->save();
                    }
                }
            }
        }
    }

    public static function seedMainTranslations()
    {
        // Main Module
        self::seedTranslations();

        // Seed Translation for SAAS Version
        if (app_type() == 'saas') {
            self::seedTranslations('Superadmin');
        }
    }

    public static function seedAllModulesTranslations()
    {
        // Main Module
        self::seedMainTranslations();

        $allModules = Module::all();
        foreach ($allModules as $allModule) {
            self::seedTranslations($allModule);
        }
    }
}
